﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Data.SqlClient
Imports System.Data

Public Class Form1

    ' 初始化用于连接数据库和向用户显示
    ' 连接错误的常量。
    Protected Const SqlConnectionString As String = _
        "Server=(local);" & _
        "DataBase=;" & _
        "Integrated Security=SSPI"

    Protected Const ConnectionErrorMessage As String = _
        "To run this sample, you must have SQL " & _
        "installed.  For " & _
        "instructions on installing SQL, view the documentation file."

    Protected didPreviouslyConnect As Boolean = False
    Protected didCreateTable As Boolean = False
    Protected connectionString As String = SqlConnectionString

#Region "创建数据库"
    ' 处理“Create Database”（创建数据库）按钮的单击事件。
    Private Sub btnCreateDB_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateDB.Click

        ' 如果“Create Table”（创建表）按钮是启用的，则表明用户尝试在相同
        ' 的应用程序运行中重新创建数据库。就此操作产生的影响向
        ' 用户发出警告，如果用户想要继续，则将 UI 重置为其
        ' 初始状态，这样当不按顺序单击当前启用的按钮时不会引入
        ' 错误。
        If btnCreateTable.Enabled Then
            Dim dr As DialogResult = MessageBox.Show("Recreating the database " & _
                "will undo the other database object creation steps you have " & _
                "made so far. Do you wish to proceed?", "Database Re-creation " & _
                "Warning", MessageBoxButtons.YesNo, MessageBoxIcon.Warning)

            If dr = Windows.Forms.DialogResult.Yes Then
                ResetUI()
                CreateDatabase()
            End If
        Else
            CreateDatabase()
        End If

    End Sub


    ' 此例程执行删除数据库（如果存在）然后再进行
    ' 创建的 SQL 语句。
    Private Sub CreateDatabase()
        Dim sqlStatement As String = _
            "IF EXISTS (" & _
            "SELECT * " & _
            "FROM master..sysdatabases " & _
            "WHERE Name = 'HowToDemo')" & vbCrLf & _
            "DROP DATABASE HowToDemo" & vbCrLf & _
            "CREATE DATABASE HowToDemo"

        ' 显示说明现在正在尝试进行连接的状态消息。
        ' 这仅在第一次尝试进行连接时才需要。
        ' 已经确定安装了 MSDE 或 SQL Server 时，
        ' 不再需要显示此消息。
        Dim statusForm As New Status()
        If Not didPreviouslyConnect Then
            statusForm.Show("Connecting to SQL Server")
        End If

        ' 尝试连接 SQL Server 实例。
        Try
            ' 利用 SqlConnection 类可与 SQL Server 进行通信。
            ' 构造函数将连接字符串作为参数接受。此
            ' 连接字符串采用集成安全性，这意味着要能够正常工作，您 
            ' 必须能够登录到 SQL Server，或者是 Administrators 
            ' 组中的一员。
            Dim connection As New SqlConnection(connectionString)

            ' SqlCommand 对象用于执行 SQL 命令。
            Dim cmd As New SqlCommand(sqlStatement, connection)

            ' 打开连接，执行命令，然后关闭
            ' 连接。无数据返回时，使用 ExecuteNonQuery
            ' 可提高效率。
            connection.Open()
            cmd.ExecuteNonQuery()
            connection.Close()

            ' 数据已成功提交。
            didPreviouslyConnect = True
            didCreateTable = True
            statusForm.Close()

            ' 显示下一步中使用的控件。
            lblArrow1.Visible = True
            lblStep2.Enabled = True
            btnCreateTable.Enabled = True

            MsgBox("Database 'HowToDemo' successfully created.", MsgBoxStyle.OKOnly, "Database Creation Status")
        Catch sqlExc As SqlException
            MsgBox(sqlExc.Message, MsgBoxStyle.OKOnly, "SQL Exception Error")
        Catch exc As Exception
            ' 无法连接 SQL Server 或 MSDE
            statusForm.Close()
            MsgBox(exc.Message, MsgBoxStyle.OKOnly, "Connection failed.")
        End Try
    End Sub
#End Region

#Region "重置用户界面"
    ' 设置用户界面，以便用户按照正确的顺序
    ' 执行各个步骤。
    Private Sub ResetUI()
        lblArrow1.Visible = False
        lblStep2.Enabled = False
        btnCreateTable.Enabled = False
        lblArrow2.Visible = False
        lblStep3.Enabled = False
        btnCreateSP.Enabled = False
        lblArrow3.Visible = False
        lblStep4.Enabled = False
        btnCreateView.Enabled = False
        lblArrow4.Visible = False
        lblStep5.Enabled = False
        btnPopulate.Enabled = False
        lblArrow5.Visible = False
        lblStep6.Enabled = False
        btnDisplay.Enabled = False

        With DataGridView1
            .Visible = False
            .DataSource = Nothing
        End With
    End Sub
#End Region

#Region "创建表"
    ' 处理“Create Table”（创建表）按钮的单击事件。
    Private Sub btnCreateTable_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateTable.Click

        Dim strSQL As String = _
            "USE HowToDemo" & vbCrLf & _
            "IF EXISTS (" & _
            "SELECT * " & _
            "FROM HowToDemo.dbo.sysobjects " & _
            "WHERE Name = 'Contact' " & _
            "AND TYPE = 'u')" & vbCrLf & _
            "BEGIN" & vbCrLf & _
            "DROP TABLE HowToDemo.dbo.Contact" & vbCrLf & _
            "END" & vbCrLf & _
            "CREATE TABLE Contact (" & _
            "ContactID Int NOT NULL," & _
            "FirstName NVarChar(40) NOT NULL," & _
            "LastName NVarChar(40) NOT NULL" & ")"

        Try
            ' 利用 SqlConnection 类可与 SQL Server 进行通信。
            ' 构造函数将连接字符串作为参数接受。此
            ' 连接字符串采用集成安全性，这意味着要能正常工作，您 
            ' 必须能够登录到 SQL Server，或者是 Administrators 
            ' 组中的一员。
            Dim dbConnection As New SqlConnection(connectionString)

            ' SqlCommand 对象用于执行 SQL 命令。
            Dim cmd As New SqlCommand(strSQL, dbConnection)

            ' 打开连接，执行命令，然后关闭连接。
            ' 无数据返回时，使用 ExecuteNonQuery 可提高
            ' 效率。
            dbConnection.Open()
            cmd.ExecuteNonQuery()
            dbConnection.Close()

            ' 显示下一步中使用的控件。
            lblArrow2.Visible = True
            lblStep3.Enabled = True
            btnCreateSP.Enabled = True

            MessageBox.Show("Table 'Contact' successfully created.", _
                "Table Creation Status", _
                MessageBoxButtons.OK, MessageBoxIcon.Information)

        Catch sqlExc As SqlException
            MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
#End Region

#Region "创建存储过程"
    ' 处理“Create Procedure”（创建存储过程）按钮的单击事件。此处理程序执行
    ' 两个 SQL 语句，一个语句删除过程（如果存在），另一个
    ' 语句则创建过程。语句要以这种方式断开，因为
    ' SQL Server 不允许它们组合在一个批处理中。（可以
    ' 在使用 GO 关键字并从 SQL 查询分析器或其他工具
    ' 执行时将它们组合起来，但不可以从代码中执行。）
    Private Sub btnCreateSP_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateSP.Click
        ' 利用 SqlConnection 类可与 SQL Server 进行通信。
        ' 构造函数将连接字符串作为参数接受。此
        ' 连接字符串采用集成安全性，这意味着要能正常工作，您 
        ' 必须能够登录到 SQL Server，或者是 Administrators 
        ' 组中的一员。
        Dim dbConnection As New SqlConnection(connectionString)

        Dim strSQL As String = _
            "USE HowToDemo" & vbCrLf & _
            "IF EXISTS (" & _
            "SELECT * " & _
            "FROM HowToDemo.dbo.sysobjects " & _
            "WHERE Name = 'AddContacts' " & _
            "AND TYPE = 'p')" & vbCrLf & _
            "BEGIN" & vbCrLf & _
            "DROP PROCEDURE AddContacts" & vbCrLf & _
            "END"

        ' SqlCommand 对象用于执行 SQL 命令。
        Dim cmd As New SqlCommand(strSQL, dbConnection)

        Try
            ' 打开连接，执行命令，然后关闭连接。
            ' 无数据返回时，使用 ExecuteNonQuery 可提高
            ' 效率。
            dbConnection.Open()
            cmd.ExecuteNonQuery()

        Catch sqlExc As SqlException
            MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

        Try
            cmd.CommandText = _
                "CREATE PROCEDURE AddContacts AS" & vbCrLf & _
                "INSERT INTO Contact" & vbCrLf & _
                "(ContactID, FirstName, LastName)" & _
                "SELECT EmployeeID, FirstName, LastName " & _
                "FROM Northwind.dbo.Employees"

            cmd.ExecuteNonQuery()
            dbConnection.Close()

            ' 显示下一步中使用的控件。
            lblArrow3.Visible = True
            lblStep4.Enabled = True
            btnCreateView.Enabled = True

            MessageBox.Show("Stored Procedure 'AddContacts' successfully " & _
                "created.", "SPROC Creation Status", _
                MessageBoxButtons.OK, MessageBoxIcon.Information)

        Catch sqlExc As SqlException
            MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
#End Region

#Region "创建视图"
    ' 处理“Create View”（创建视图）按钮的单击事件。此处理程序执行
    ' 两个 SQL 语句，一个语句删除视图（如果存在），另一个
    ' 语句则创建视图。语句要以这种方式断开，因为
    ' SQL Server 不允许它们组合在一个批处理中。（可以
    ' 在使用 GO 关键字并从 SQL 查询分析器或其他工具
    ' 执行时将它们组合起来，但不可以从代码中执行。）
    Private Sub btnCreateView_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateView.Click
        ' 利用 SqlConnection 类可与 SQL Server 进行通信。
        ' 构造函数将连接字符串作为参数接受，此
        ' 连接字符串采用集成安全性，这意味着要能正常工作，您 
        ' 必须能够登录到 SQL Server，或者是 Administrators
        ' 组中的一员。
        Dim dbConnection As New SqlConnection(connectionString)

        Dim strSQL As String = _
            "USE HowToDemo" & vbCrLf & _
            "IF EXISTS (" & _
            "SELECT * " & _
            "FROM HowToDemo.dbo.sysobjects " & _
            "WHERE Name = 'GetContacts' " & _
            "AND TYPE = 'v')" & vbCrLf & _
            "BEGIN" & vbCrLf & _
            "DROP VIEW GetContacts" & vbCrLf & _
            "END"

        ' SqlCommand 对象用于执行 SQL 命令。
        Dim cmd As New SqlCommand(strSQL, dbConnection)

        Try
            ' 打开连接，执行命令。现在不要关闭
            ' 连接，因为它还要用在下一个 Try...Catch 块中。
            dbConnection.Open()
            cmd.ExecuteNonQuery()

        Catch sqlExc As SqlException
            MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

        Try
            ' 更改 SQL 语句以进行下一次查询。
            cmd.CommandText = _
                "CREATE VIEW GetContacts AS " & _
                "SELECT * " & _
                "FROM Contact"

            cmd.ExecuteNonQuery()
            dbConnection.Close()

            ' 显示下一步中使用的控件。
            lblArrow4.Visible = True
            lblStep5.Enabled = True
            btnPopulate.Enabled = True

            MessageBox.Show("View 'GetContacts' successfully " & _
                "created.", "SQL View Creation Status", _
                MessageBoxButtons.OK, MessageBoxIcon.Information)

        Catch sqlExc As SqlException
            MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
#End Region

#Region "填充表"
    ' 处理“Populate”（填充）按钮的单击事件。此处理程序执行
    ' 使用 AdventureWorks 数据库的 Contact 表中的产品信息
    ' 填充 Contact 表的存储过程。
    Private Sub btnPopulate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPopulate.Click

        Dim strSQL As String = "EXECUTE HowToDemo.dbo.AddContacts"

        Try
            ' 利用 SqlConnection 类可与 SQL Server 进行通信。
            ' 构造函数将连接字符串作为参数接受，此
            ' 连接字符串采用集成安全性，这意味着要能正常工作，您 
            ' 必须能够登录到 SQL Server，或者是 Administrators
            ' 组中的一员。
            Dim dbConnection As New SqlConnection(connectionString)

            ' SqlCommand 对象用于执行 SQL 命令。
            Dim cmd As New SqlCommand(strSQL, dbConnection)

            ' 打开连接，执行命令，然后关闭连接。
            ' 无数据返回时，使用 ExecuteNonQuery 可提高
            ' 效率。
            dbConnection.Open()
            cmd.ExecuteNonQuery()
            dbConnection.Close()

            ' 显示下一步中使用的控件。
            lblArrow5.Visible = True
            lblStep6.Enabled = True
            btnDisplay.Enabled = True

            MessageBox.Show("Table successfully populated.", _
                "Data Addition Status", _
                MessageBoxButtons.OK, MessageBoxIcon.Information)

        Catch sqlExc As SqlException
            MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
#End Region

#Region "显示数据"
    ' 处理“Display”（显示）按钮的单击事件。此处理程序从
    ' Contact 表获取产品信息，并将其放入用于绑定到
    ' DataGrid 的数据集中以进行显示。自定义样式
    ' 对象用于为 DataGrid 提供好看的外观。
    Private Sub btnDisplay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDisplay.Click

        If IsNothing(DataGridView1.DataSource) Then

            Dim strSQL As String = _
                "USE HowToDemo" & vbCrLf & _
                "SELECT * " & _
                "FROM GetContacts"

            Try
                ' 利用 SqlConnection 类可与 SQL Server 进行通信。
                ' 构造函数将连接字符串作为参数接受，此
                ' 连接字符串采用集成安全性，这意味着要能正常工作，您 
                ' 必须能够登录到 SQL Server，或者是 Administrators
                ' 组中的一员。
                Dim dbConnection As New SqlConnection(connectionString)

                ' SqlCommand 对象用于执行 SQL 命令。
                Dim cmd As New SqlCommand(strSQL, dbConnection)

                ' SqlDataAdapter 负责使用 SqlCommand 对象
                ' 填充数据集。
                Dim da As New SqlDataAdapter(cmd)
                Dim dsContacts As New DataSet()
                da.Fill(dsContacts, "Contact")

                With Me.DataGridView1
                    .Visible = True
                    .AutoGenerateColumns = False
                    .AlternatingRowsDefaultCellStyle.BackColor = Color.Lavender
                    .BackColor = Color.WhiteSmoke
                    .ForeColor = Color.MidnightBlue
                    .CellBorderStyle = DataGridViewCellBorderStyle.None
                    .ColumnHeadersDefaultCellStyle.Font = New Font("Tahoma", 8.0!, FontStyle.Bold)
                    .ColumnHeadersDefaultCellStyle.BackColor = Color.MidnightBlue
                    .ColumnHeadersDefaultCellStyle.ForeColor = Color.WhiteSmoke
                    .DefaultCellStyle.ForeColor = Color.MidnightBlue
                    .DefaultCellStyle.BackColor = Color.WhiteSmoke
                End With


                Me.DataGridView1.DataSource = dsContacts.Tables(0)
                Dim newColumn As Integer = Me.DataGridView1.Columns.Add("ContactID", "Contact ID")
                Me.DataGridView1.Columns(newColumn).DataPropertyName = "ContactID"

                newColumn = Me.DataGridView1.Columns.Add("FirstName", "First Name")
                Me.DataGridView1.Columns(newColumn).DataPropertyName = "FirstName"

                newColumn = Me.DataGridView1.Columns.Add("LastName", "Last Name")
                Me.DataGridView1.Columns(newColumn).DataPropertyName = "LastName"
            Catch sqlExc As SqlException
                MessageBox.Show(sqlExc.ToString, "SQL Exception Error!", _
                    MessageBoxButtons.OK, MessageBoxIcon.Error)
            End Try
        End If

    End Sub
#End Region

#Region "窗体加载"
    ' 处理窗体加载事件。
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ResetUI()
    End Sub
#End Region

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
